// Generate random hex color
function randomHex() {
  const n = Math.floor(Math.random() * 0xffffff);
  return "#" + n.toString(16).padStart(6, "0").toUpperCase();
}

const palette = document.getElementById("palette");
const countInput = document.getElementById("count");
const generateBtn = document.getElementById("generate");
const randomizePartialBtn = document.getElementById("randomizePartial");

// Copy hex to clipboard
function copyToClipboard(hex, badge) {
  navigator.clipboard.writeText(hex).then(() => {
    badge.classList.add("show");
    setTimeout(() => badge.classList.remove("show"), 1200);
  });
}

// Create a single swatch element
function createSwatch(hex) {
  const swatch = document.createElement("div");
  swatch.classList.add("swatch");

  const copied = document.createElement("div");
  copied.className = "copied-badge";
  copied.textContent = "COPIED";
  swatch.appendChild(copied);

  const top = document.createElement("div");
  top.className = "top";
  top.style.background = hex;
  swatch.appendChild(top);

  const meta = document.createElement("div");
  meta.className = "meta";

  const hexEl = document.createElement("div");
  hexEl.className = "hex";
  hexEl.textContent = hex;
  hexEl.addEventListener("click", () => copyToClipboard(hex, copied));

  const lockBtn = document.createElement("button");
  lockBtn.className = "btn lock-btn";
  lockBtn.textContent = "🔓";
  lockBtn.addEventListener("click", () => {
    const locked = swatch.classList.toggle("locked");
    lockBtn.textContent = locked ? "🔒" : "🔓";
  });

  meta.appendChild(hexEl);
  meta.appendChild(lockBtn);

  swatch.appendChild(meta);
  return swatch;
}

// Render a full palette
function renderPalette(count) {
  palette.innerHTML = "";
  for (let i = 0; i < count; i++) {
    const color = randomHex();
    const swatch = createSwatch(color);
    palette.appendChild(swatch);
  }
}

// Randomize unlocked colors only
function randomizeUnlocked() {
  document.querySelectorAll(".swatch").forEach((swatch) => {
    if (swatch.classList.contains("locked")) return;
    const newColor = randomHex();
    swatch.querySelector(".top").style.background = newColor;
    const hexEl = swatch.querySelector(".hex");
    hexEl.textContent = newColor;
  });
}

// Event listeners
generateBtn.addEventListener("click", () => {
  const n = Number(countInput.value);
  if (n < 2 || n > 8) {
    alert("Please choose between 2 and 8 colors.");
    return;
  }
  renderPalette(n);
});

randomizePartialBtn.addEventListener("click", randomizeUnlocked);

// Initialize
renderPalette(Number(countInput.value) || 5);
